<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_category_list extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-category-list';
    }

    public function get_title() {
        return esc_html__( 'Categories List', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'wesper'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
            ]
        ); 
        $this->add_control(
      'number_cat',
      array(
        'label'       => esc_html__( 'Number of categories', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
                 

      $this->end_controls_section();      
      //Title Style Section
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     
 
      $this->add_control(
      'jl_cat_layout',
      array(
        'label'       => esc_html__( 'Categories layout', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [                        
                        'style1'        => esc_html__( 'Overlay middle text', 'wesper' ),
                        'style2'        => esc_html__( 'Overlay bottom text', 'wesper' ),
                        'style3'        => esc_html__( 'Image on top', 'wesper' ),
                        'style4'        => esc_html__( 'Image text with background', 'wesper' ),
                    ],
        'default'     => 'style1',
      )
    );   

      $this->add_control(
      'section_btn_text', [
        'label'       => esc_html__( 'Text count', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'default'   => ' Articles',
        'condition' => [
                    'jl_cat_layout'    => ['style3']
        ]
      ]
      );

      $this->add_responsive_control(
        'jl_item_cols',
        [
            'label' => __( 'Number of columns', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 4,
            ],
            'tablet_default' => [
              'size' => 4,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_cat_lopt' => 'grid-template-columns: repeat({{SIZE}},minmax(0,1fr)) !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'jl_item_cols_space',
        [
            'label' => __( 'Columns space', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_cat_lopt' => 'grid-column-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

        $this->add_responsive_control(
        'jl_item_row_space',
        [
            'label' => __( 'Row space', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_cat_lopt' => 'grid-row-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'sl_cat_size',
        [
            'label' => __( 'Categories height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_cat_lopt' => '--jl-cat-hs: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'slfont_size',
        [
            'label' => __( 'Title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 17,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_cat_lopt .jl_cat_lbw .jl_cm_name' => 'font-size: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'g_sm_img',
        [
            'label' => __( 'Categories broder radius', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_cat_lopt .jl_radus_e, {{WRAPPER}} .jl_cat_opt3.jl_cat_lopt .jl_cimg' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
    );   
    
    $this->add_responsive_control(
      'cat_txt_space',
      [
          'label' => __( 'Categories space', 'wesper' ),
          'type' => Controls_Manager::SLIDER,            
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_cat_opt4 .jl_cat_lbw' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
          ],
          'condition' => [
              'jl_cat_layout'    => 'style4'
          ]
      ]
  );   

    $this->add_control(
      'title_color',
      [
        'label' => __( 'Title color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jl_cat_opt3 .jl_cat_lbw .jl_cm_name' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'jl_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'title_color_dark',
      [
        'label' => __( 'Title color dark mode', 'wesper' ),
        'default' => '#fff',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_cat_opt3 .jl_cat_lbw .jl_cm_name' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'jl_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'desc_color',
      [
        'label' => __( 'Number label color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#707070',
        'selectors' => [
            '{{WRAPPER}} .jl_cat_opt3 .jl_cm_count' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'jl_cat_layout'    => ['style3']
        ]
      ]
    );

    $this->add_control(
      'desc_color_dark',
      [
        'label' => __( 'Number label color dark mode', 'wesper' ),
        'default' => '#ababab',
        'type' => Controls_Manager::COLOR,        
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_cat_opt3 .jl_cm_count' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'jl_cat_layout'    => ['style3']
        ]
      ]
    );
    
      $this->end_controls_section();

    }

    protected function render( ) { 
        $settings = $this->get_settings_for_display();
        $categories = $settings['categories'];
        $number_cat = $settings['number_cat'];
        $jl_cat_layout = $settings['jl_cat_layout'];
        $section_btn_text = $settings['section_btn_text'];
    
        
        if($settings['categories']){
            $cat_id = implode(',', $settings['categories']);      
        }else{
          $cat_id = "";
        }
            $args = array(
            'orderby'       => 'include', 
            'order'         => 'ASC',
            'hide_empty'    => false,
            'fields'        => 'all',
            'pad_counts'    => false, 
            'include'       => $cat_id,
            'number'        => $number_cat,
            );
            $categories = get_terms('category', $args);
            if ($categories) {
                switch ( $jl_cat_layout ) {
                    case 'style1':
                        echo '<div class="jl_cat_lopt jl_cat_opt1">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $jelly_header_id = absint( get_term_meta( $tag->term_id, 'jelly_header_id', true ) );
                            echo '<div class="jl_cat_opt_w jl_radus_e jl_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="jl_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($jelly_header_id){
                                echo '<div class="jl_cimg">';
                                echo wp_get_attachment_image( $jelly_header_id, 'wesper_layouts', "", array( "class" => "jl_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="jl_cat_lbw"><span class="jl_cm_name">'.esc_attr($tag->name).'</span><span class="jl_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style2':
                        echo '<div class="jl_cat_lopt jl_cat_opt2">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $jelly_header_id = absint( get_term_meta( $tag->term_id, 'jelly_header_id', true ) );
                            echo '<div class="jl_cat_opt_w jl_radus_e jl_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="jl_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($jelly_header_id){
                                echo '<div class="jl_cimg">';
                                echo wp_get_attachment_image( $jelly_header_id, 'wesper_layouts', "", array( "class" => "jl_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="jl_cat_lbw"><span class="jl_cm_name">'.esc_attr($tag->name).'</span><span class="jl_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style3':
                        echo '<div class="jl_cat_lopt jl_cat_opt3">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $jelly_header_id = absint( get_term_meta( $tag->term_id, 'jelly_header_id', true ) );
                            echo '<div class="jl_cat_opt_w jl_radus_e jl_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="jl_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($jelly_header_id){
                                echo '<div class="jl_cimg">';
                                echo wp_get_attachment_image( $jelly_header_id, 'wesper_layouts', "", array( "class" => "jl_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="jl_cat_lbw"><span class="jl_cm_name">'.esc_attr($tag->name).'</span><span class="jl_cm_count">'.esc_attr($tag->count).$section_btn_text.'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                    case 'style4':
                        echo '<div class="jl_cat_lopt jl_cat_opt4">';
                        foreach( $categories as $tag) {
                          $tag_link = get_category_link($tag->term_id);
                          $jelly_header_id = absint( get_term_meta( $tag->term_id, 'jelly_header_id', true ) );
                            echo '<div class="jl_cat_opt_w jl_radus_e jl_cat_cid_'.esc_attr($tag->term_id).'">';
                            echo '<a class="jl_cat_img_link" aria-label="'.esc_attr($tag->name).'" href="'.esc_url($tag_link).'"></a>';                               
                            if ($jelly_header_id){
                                echo '<div class="jl_cimg">';
                                echo wp_get_attachment_image( $jelly_header_id, 'wesper_layouts', "", array( "class" => "jl_f_img_bg" ) );              
                                echo '</div>';
                            }
                            echo '<span class="jl_cat_lbw"><span class="jl_cm_name">'.esc_attr($tag->name).'</span><span class="jl_cm_count">'.esc_attr($tag->count).'</span></span>';
                            echo '</div>';
                        }
                        echo "</div>";
                    break;
                }            
            }

    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }
   
}