<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class wesper_section_current_date extends Widget_Base {

    public function get_name() {
        return 'wesper-current-date';
    }

    public function get_title() {
        return esc_html__( 'Jelly Current Date', 'wesper' );
    }

    public function get_icon() {
        return 'eicon-calendar jl-icons';
    }

    public function get_categories() {
        return [ 'wesper-elements-head' ];
    }

    protected function register_controls() {
    $this->start_controls_section(
            'text_elements',
            [
                'label' => __( 'Date Settings', 'wesper' ),
            ]
        );
        
        $this->add_control(
            'current_date', [
              'label'       => esc_html__( 'Date format', 'wesper' ),
              'type'        => Controls_Manager::TEXT,
              'label_block' => true,
              'default'     => 'l ,  j  F Y'
            ]
            );   
        $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography', 
                    'label' =>esc_html__( 'Date typography', 'wesper' ),               
                    'selector' => '{{WRAPPER}} .jl_cur_date',                    
                ]
            );
        $this->add_control(
            'jl_date_color',
            [
                'label' =>esc_html__( 'Color', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .jl_cur_date' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->add_control(
            'jl_date_color_dark',
            [
                'label' =>esc_html__( 'Color dark mode', 'wesper' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FFF',
                'selectors' => [
                    '.options_dark_skin {{WRAPPER}} .jl_cur_date' => 'color: {{VALUE}} !important;',                    
                ],
            ]
        );  

        $this->end_controls_section();        
    }
    protected function render( ) {
       $settings = $this->get_settings_for_display();   
       $current_date = $settings['current_date'];     
       ?>
       <div class="jl_cur_date">
        <?php echo date_i18n( $current_date, current_time( 'timestamp' ) ); ?>
       </div>      
    <?php
    }
}