<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_feature_box extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-feature-box';
    }

    public function get_title() {
        return esc_html__( 'Feature Box', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Feature Box Setting', 'wesper'),
            ]
        );

        $repeater = new Repeater();        
        $repeater->add_control(
        'box_image', [
            'label' => __( 'Image', 'wesper' ),
            'type' => Controls_Manager::MEDIA,
            'label_block' => true,
          ]
        );
        $repeater->add_control(
        'box_title', [
            'label' => __( 'Title', 'wesper' ),
            'type' => Controls_Manager::TEXT,
            'default' => __( 'Title' , 'wesper' ),
          ]
        );
        $repeater->add_control(
        'box_label', [
            'label' => __( 'Title', 'wesper' ),
            'type' => Controls_Manager::TEXT,
            'default' => __( 'label' , 'wesper' ),
          ]
        );
        $repeater->add_control(
        'box_link', [
            'label' => __( 'Link URL', 'wesper' ),
            'type' => Controls_Manager::URL,
            'default' => [
                  'url' => '#',
                  'is_external' => true,
               ],
            'show_external' => true,
          ]                   
        );

        $this->add_control(
      'box_info',
      [
        'label' => __( 'Box info', 'wesper' ),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
            [
              'box_title' => __( 'List Item 1', 'wesper' ),              
            ],
            [
              'box_title' => __( 'List Item 2', 'wesper' ),              
            ],
            [
              'box_title' => __( 'List Item 3', 'wesper' ),              
            ],
    ],

        'title_field' => '{{{ box_title }}}',
      ]
    );                  
      
    $this->end_controls_section();
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Feature Box Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
    );

        $this->add_control(
          'jl_line_sh',
          [
              'label' => esc_html__( 'Show line overlay', 'wesper' ),
              'type' => Controls_Manager::SWITCHER,              
              'selectors' => [
                '{{WRAPPER}} .jl_box_w .jl_box_link:before' => "border: 1px solid #fff; top: 20px; left: 20px; right: 20px; bottom: 20px; opacity: .35; content: ''; position: absolute;",
                ]
          ]
    );

      $this->add_responsive_control(
        'jl_box_cols',
        [
            'label' => __( 'Number of columns', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 3,
            ],
            'tablet_default' => [
              'size' => 3,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 12,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_box_w' => '--jl-box-cols: {{SIZE}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'box_height',
        [
            'label' => __( 'Box height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 600,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_box_w' => '--jl-box-h: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
    );  

      $this->add_responsive_control(
        'box_lbl_w',
        [
            'label' => __( 'Box label width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 100,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_box_w .jl_box_txtw' => 'width: {{SIZE}}% !important;',
            ],
        ]
    );  

    $this->add_responsive_control(
      'box_lbl_h',
      [
          'label' => __( 'Box label height', 'wesper' ),
          'type' => Controls_Manager::SLIDER,
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 600,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_box_w' => '--jl-lbl-h: {{SIZE}}{{UNIT}} !important;',
          ],
      ]
  );  

    $this->add_responsive_control(
        'box_spacing',
        [
            'label' => __( 'Box spacing between', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 20,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_box_w' => '--jl-box-gap: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
    );    
    
    $this->add_responsive_control(
      'box_radius',
      [
          'label' => __( 'Box rounded corners', 'wesper' ),
          'type' => Controls_Manager::SLIDER,          
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 300,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_box_w .jl_box_info' => 'border-radius: {{SIZE}}{{UNIT}} !important;',
          ],
      ]
  );  
  
  $this->add_responsive_control(
    'label_radius',
    [
        'label' => __( 'Label rounded corners', 'wesper' ),
        'type' => Controls_Manager::SLIDER,          
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 300,
                'step' => 1,
            ]
        ],
        'selectors' => [
        '{{WRAPPER}} .jl_box_w .jl_box_txtw' => 'border-radius: {{SIZE}}{{UNIT}} !important;',
        ],
    ]
);  

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
          'name' => 'box_font_size',
          'label' => __( 'Title Typography', 'wesper' ),
          'selector' => '{{WRAPPER}} .jl_box_w .jl_box_title',
      ]
  );

  $this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'box_label_size',
        'label' => __( 'Label Typography', 'wesper' ),
        'selector' => '{{WRAPPER}} .jl_box_w .jl_box_label',
    ]
); 

    $this->add_control(
      'label_bg',
      [
        'label' => __( 'Label background', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
          '{{WRAPPER}} .jl_box_w' => '--jl-box-bg: {{VALUE}}',
        ]
      ]
    );

    $this->add_control(
      'label_bg_dark',
      [
        'label' => __( 'Label background dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR, 
        'default' => '#222',       
        'selectors' => [
          '.options_dark_skin {{WRAPPER}} .jl_box_w' => '--jl-box-bg: {{VALUE}}',
        ]
      ]
    );

    $this->add_control(
      'title_color',
      [
        'label' => __( 'Title color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
          '{{WRAPPER}} .jl_box_w' => '--jl-title-color: {{VALUE}}',
        ]
      ]
    );

    $this->add_control(
      'title_color_dark',
      [
        'label' => __( 'Title color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
          '.options_dark_skin {{WRAPPER}} .jl_box_w' => '--jl-title-color: {{VALUE}}',
        ]
      ]
    );

    $this->add_control(
      'label_color',
      [
        'label' => __( 'Label color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#666666',
        'selectors' => [
          '{{WRAPPER}} .jl_box_w' => '--jl-lbl-color: {{VALUE}}',
        ]
      ]
    );

    $this->add_control(
      'label_color_dark',
      [
        'label' => __( 'Label color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#ddd',
        'selectors' => [
          '.options_dark_skin {{WRAPPER}} .jl_box_w' => '--jl-lbl-color: {{VALUE}}',
        ]
      ]
    );

        $this->end_controls_section();
    }
    protected function render( ) {
    $settings = $this->get_settings_for_display();
    $box_info = $settings['box_info'];
    if(!empty($box_info)){
?>
<div class="jl_box_c jl_clear_at">
  <div class="jl_box_w">
    <?php
    $counter = 1;
    foreach ($box_info as $index => $slide){
    ?>
    <div class="jl_box_info jl_radus_e">
        <span class="jl_box_txtw jl_radus_e">
        <span class="jl_box_txtin">
        <?php if(!empty($slide['box_title'])){?>
        <span class="jl_box_title"><?php echo esc_html($slide['box_title']); ?></span>
        <?php }?>
        <?php if(!empty($slide['box_label'])){?>
        <span class="jl_box_label"><?php echo esc_html($slide['box_label']); ?></span>
        <?php }?>
        </span>
        </span>
        <?php
        if(!empty($slide['box_link']['url'])){
            $link_key = 'link_' . $index;
            $this->add_link_attributes( $link_key, $slide['box_link'] );
        ?>
        <a class="jl_box_link" <?php echo $this->get_render_attribute_string( $link_key ); ?>></a>
        <?php }?>
        <div class="jl_box_bg">
        <?php echo wp_get_attachment_image($slide['box_image']['id'], 'wesper_layouts', "", array( "class" => "jl_f_img_bg" ));?>
        </div>
    </div>          
    <?php $counter++; } ?>
  </div>
</div>
<?php }
    }
}