<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_feature_layout20 extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-feature-layout20';
    }

    public function get_title() {
        return esc_html__( 'Overlay 2 + below 3', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {

    $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'wesper'),
              'description' => esc_html__( 'Choose post type to display posts', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'wesper'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'wesper' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'wesper' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'wesper'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'wesper' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'wesper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'wesper'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
              

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'wesper' ),
                        'gallery'        => esc_html__( 'Gallery', 'wesper' ),
                        'video'        => esc_html__( 'Video', 'wesper' ),
                        'audio'        => esc_html__( 'Audio', 'wesper' ),
                        'quote'        => esc_html__( 'Quote', 'wesper' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );     

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'wesper' ),                        
                  'rand'      =>esc_html__( 'Random', 'wesper' ),
                  'update'      =>esc_html__( 'Latest updated', 'wesper' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'wesper' ),
                  'author'      =>esc_html__( 'Author', 'wesper' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'wesper' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'wesper' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'wesper' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'wesper' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'wesper' ),
              ],
            ]
        );

    $this->end_controls_section();
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     

        $this->add_control(
          'jl_cus_img',
          [
              'label'     =>esc_html__( 'Image size', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => '',
              'options'   => [
                      ''      =>esc_html__( 'Default image size', 'wesper' ),      
                      'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
                      'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
                      'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
                      'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
                      'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
                  ],
          ]
      ); 
 
     $this->add_responsive_control(
        'mf_font_size',
        [
            'label' => __( 'Main title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 28,
            ],
            'tablet_default' => [
              'size' => 28,
            ],
            'mobile_default' => [
              'size' => 22,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-font-main: {{SIZE}}{{UNIT}};',            
            ],
        ]
      );      

      $this->add_responsive_control(
        'sf_font_size',
        [
            'label' => __( 'Small title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 17,
            ],
            'tablet_default' => [
              'size' => 17,
            ],
            'mobile_default' => [
              'size' => 16,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-font-small: {{SIZE}}{{UNIT}};',            
            ],
        ]
      );     

        $this->add_responsive_control(
        'imgm_height',
        [
            'label' => __( 'Image main height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 50,
            ],
            'tablet_default' => [
              'size' => 40,
            ],
            'mobile_default' => [
              'size' => 70,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-main-h: {{SIZE}}%;',
            ]
        ]
      );

        $this->add_responsive_control(
        'imgs_height',
        [
            'label' => __( 'Image small height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 65,
            ],
            'tablet_default' => [
              'size' => 50,
            ],
            'mobile_default' => [
              'size' => 100,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-small-h: {{SIZE}}%;',
            ]
        ]
      );

        $this->add_responsive_control(
        'grid_spacing',
        [
            'label' => __( 'Grid Spacing', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 3,
            ],
            'tablet_default' => [
              'size' => 3,
            ],
            'mobile_default' => [
              'size' => 1,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-grid-gap: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'capm_padding',
        [
            'label' => __( 'Caption main padding', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 30,
            ],
            'tablet_default' => [
              'size' => 30,
            ],
            'mobile_default' => [
              'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-padding-main: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'caps_padding',
        [
            'label' => __( 'Caption small padding', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'default' => [
            'size' => 20,
            ],
            'tablet_default' => [
              'size' => 20,
            ],
            'mobile_default' => [
              'size' => 15,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 400,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jl-padding-small: {{SIZE}}{{UNIT}};',
            ]
        ]
      );

        $this->add_responsive_control(
        'sl_radius',
        [
            'label' => __( 'Post border radius', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 300,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_fr20_inner' => '--jlc-car-radius: {{SIZE}}{{UNIT}};',
            ],
        ]
      );  

      $this->add_responsive_control(
        'jl_num_text_line',
        [
            'label' => __( 'Number line of text', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 10,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_ov_el .jl_fe_text .jl_fe_title' => '-webkit-line-clamp: {{SIZE}};',            
            ],
        ]
    ); 

      $this->add_control(
        'jl_gradient_ov',
        [
            'label' => esc_html__( 'Enable gradient background', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => '',
            'selectors' => [
              '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'background: transparent !important; background-image: repeating-linear-gradient(0deg, #000, transparent) !important;',
            ],
        ]
    ); 
    
      $this->add_control(
        'sl_ov_bg',
        [
          'label' => __( 'Overlay background', 'wesper' ),
          'type' => Controls_Manager::COLOR,        
          'selectors' => [
              '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'background: {{VALUE}}',
          ],                
          'condition' => [
                    'jl_gradient_ov' => ''
          ]
        ]
      );

      $this->add_responsive_control(
        'jl_bg_opacity',
        [
            'label' => __( 'Opacity Overlay', 'wesper' ),
            'type' => Controls_Manager::SLIDER,            
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 1,
                    'step' => 0.1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_ov_el .jl_imgl' => 'opacity: {{SIZE}}',            
            ],
        ]
    ); 

        $this->add_control(
      'cap_h_align',
      [
        'label' => __( 'Horizontal Alignment', 'wesper' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'left' => [
            'title' => __( 'Left', 'wesper' ),
            'icon' => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => __( 'Center', 'wesper' ),
            'icon' => 'eicon-text-align-center',
          ],
          'right' => [
            'title' => __( 'Right', 'wesper' ),
            'icon' => 'eicon-text-align-right',
          ],
        ],
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .jl_fr20_inner' => '--jl-h-align: {{VALUE}}',                
            ]        
      ]
    );    

    $this->add_control(
      'cap_v_align',
      [
        'label' => __( 'Vertical Alignment', 'wesper' ),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
          'start' => [
            'title' => __( 'Top', 'wesper' ),
            'icon' => 'eicon-v-align-top',
          ],
          'center' => [
            'title' => __( 'Middle', 'wesper' ),
            'icon' => 'eicon-v-align-middle',
          ],
          'end' => [
            'title' => __( 'Bottom', 'wesper' ),
            'icon' => 'eicon-v-align-bottom',
          ],
        ],
        'toggle' => true,
        'selectors' => [
                '{{WRAPPER}} .jl_fr20_inner' => '--jl-v-align: {{VALUE}}',                
            ]        
      ]
    );      

      $this->add_control(
                'jl_hide_cat',
                [
                    'label' => esc_html__( 'Hide category', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_author',
                [
                    'label' => esc_html__( 'Hide author', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_hide_date',
                [
                    'label' => esc_html__( 'Hide date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

            $this->add_control(
                'jl_hide_meta',
                [
                    'label' => esc_html__( 'Hide author & date', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );            

            $this->add_control(
                'jl_hide_review',
                [
                    'label' => esc_html__( 'Hide review', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 

            $this->add_control(
                'jl_light_mode',
                [
                    'label' => esc_html__( 'Enable light text mode', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );   

          $this->add_control(
                'jl_hide_line',
                [
                    'label' => esc_html__( 'Hide row line', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            ); 
            $this->add_control(
                'jl_hide_col_line',
                [
                    'label' => esc_html__( 'Hide columns line', 'wesper' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'yes',
                ]
        ); 
            
          $this->add_control(
          'liline_color',
          [
            'label' => __( 'Line color', 'wesper' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .jl_lisep:after, {{WRAPPER}} .jl_risep:before' => 'border-color: {{VALUE}} !important'        
            ]
          ]
        );

          $this->add_control(
          'liline_color_dark',
          [
            'label' => __( 'Line color dark mode', 'wesper' ),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '.options_dark_skin {{WRAPPER}} .jl_lisep:after, .options_dark_skin {{WRAPPER}} .jl_risep:before' => 'border-color: {{VALUE}} !important'        
            ]
          ]
        );

        $this->end_controls_section();
    }

protected function render( ) { 
  $settings = $this->get_settings();

      if ( function_exists( 'wesper_feature_layout_2' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();      
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      echo \wesper_feature_layout_20( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'wesper' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }
   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }
}