<?php
namespace wesperElementor\Widgets;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;
use Elementor\Icons_Manager;
if ( ! defined( 'ABSPATH' ) ) exit;

class wesper_large_post extends Widget_Base {

  public $base;

    public function get_name() {
        return 'wesper-large-post';
    }

    public function get_title() {
        return esc_html__( 'Large Post', 'wesper' );
    }

    public function get_icon() { 
        return 'eicon-elementor-circle jl-icons';
    }

    public function get_categories() {
       return [ 'wesper-elements' ];
    }

    protected function register_controls() {      

      $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Post Query And Setting', 'wesper'),
            ]
        );

        $this->add_control(
          'post_type',
          [
              'label' =>esc_html__('Post types', 'wesper'),
              'description' => esc_html__( 'Choose post type to display posts', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'post',            
               'options'   => $this->post_get_type(),             
          ]
      ); 

      $this->add_control(
        'post_type_tax',
        [
            'label' =>esc_html__('Post taxonomy', 'wesper'),
            'description' => esc_html__( 'Choose post type (category or tag)', 'wesper' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => 'none',          
             'options'   => $this->post_get_taxs(),
             'condition' => [
               'post_type!'    => ['post']
             ]  
                        
        ]
    ); 

    $this->add_control(
      'term_slugs', [
        'label'       => esc_html__( 'Term Slug', 'wesper' ),
        'description' => esc_html__( 'Example: slug1,slug2,slug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type!'    => ['post']
        ]  
      ]
      );
        
        $this->add_control(
            'categories',
            [
                'label' =>esc_html__('Select Categories', 'wesper'),
                'type'      => Controls_Manager::SELECT2,
                 'options'   => $this->post_categories(),
                'label_block' => true,
                'multiple'  => true,
                'condition' => [
                  'post_type'    => ['post']
                ]  
            ]
        ); 
         

        $this->add_control(
      'tags', [
        'label'       => esc_html__( 'Tag Slug', 'wesper' ),
        'description' => esc_html__( 'Example: tagslug1,tagslug2,tagslug3', 'wesper' ),
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true,
        'condition' => [
          'post_type'    => ['post']
        ]  
      ]
      );  

        $this->add_control(
            'author',
            [
                'label' =>esc_html__('Author Filter', 'wesper'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                 'options'   => $this->post_author(),
                 'condition' => [
                   'post_type'    => ['post']
                 ]  
            ]
        ); 
        
      //   $this->add_control(
      //     'author',
      //     [
      //         'label' =>esc_html__('Select Author', 'wesper'),
      //         'type'      => Controls_Manager::SELECT2,
      //          'options'   => $this->post_author(),
      //         'label_block' => true,
      //         'multiple'  => true,
      //     ]
      // ); 
               

        $this->add_control(
      'posts_per_page',
      array(
        'label'       => esc_html__( 'Posts per Page', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6'
      )
    );

        $this->add_control(
      'offset',
      array(
        'label'       => esc_html__( 'Post Offset', 'wesper' ),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '',
      )
    );
    

    $this->add_control(
      'format',
      array(
        'label'       => esc_html__( 'Post Format', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'All', 'wesper' ),
                        'gallery'        => esc_html__( 'Gallery', 'wesper' ),
                        'video'        => esc_html__( 'Video', 'wesper' ),
                        'audio'        => esc_html__( 'Audio', 'wesper' ),
                        'quote'        => esc_html__( 'Quote', 'wesper' ),
                    ],
        'default'     => '0',
        'condition' => [
          'post_type'    => ['post']
        ]  
      )
    );     

    $this->add_control(
      'post_not_in', [
        'label'       => esc_html__( 'Exclude Post IDs', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );   

      $this->add_control(
      'post_in', [
        'label'       => esc_html__( 'Post IDs Filter', 'wesper' ),
          'description' => esc_html__( 'Example: 1,2,3', 'wesper' ),
          'default'     => '',
        'type'        => Controls_Manager::TEXT,
        'label_block'   => true
      ]
      );    

      $this->add_control(
        'ignore_sticky_posts',
        [
            'label' => esc_html__( 'Enable sticky posts', 'wesper' ),
            'type' => Controls_Manager::SWITCHER,
            'return_value' => 'yes',
            'default' => 'no',
        ]
      );

      $this->add_control(
            'order',
            [
                'label'     =>esc_html__( 'Sort Order', 'wesper' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date_post',
                'options'   => [
                  'date_post'      =>esc_html__( 'Latest post', 'wesper' ),                        
                  'rand'      =>esc_html__( 'Random', 'wesper' ),
                  'update'      =>esc_html__( 'Latest updated', 'wesper' ),
                  'comment_count'      =>esc_html__( 'Popular comment', 'wesper' ),
                  'author'      =>esc_html__( 'Author', 'wesper' ),
                  'popular_most'      =>esc_html__( 'Popular views', 'wesper' ),
                  'popular_by_month'      =>esc_html__( 'Popular views by month', 'wesper' ),
                  'popular_by_week'      =>esc_html__( 'Popular views by week', 'wesper' ),
                  'alphabetical_order_decs'      =>esc_html__( 'Title DECS', 'wesper' ),
                  'alphabetical_order_asc'      =>esc_html__( 'Title ACS', 'wesper' ),
              ],
            ]
        );          

      $this->add_control(
      'pagination',
      array(
        'label'       => esc_html__( 'Pagination', 'wesper' ),
        'type'        => Controls_Manager::SELECT,
        'options'   => [
                        '0'               => esc_html__( 'None', 'wesper' ),
                        'next_prev'       => esc_html__( 'Arrow', 'wesper' ),
                        'loadmore'        => esc_html__( 'Load More', 'wesper' ),
                        'autoload'        => esc_html__( 'Auto Load', 'wesper' ),
                    ],
        'default'     => '0',
      )
    );      

        

        $this->end_controls_section();
     
     //Title Style Section
    $this->start_controls_section(
      'section_tab_style', [
        'label'  => esc_html__( 'Post Custom Style', 'wesper' ),
        'tab'     => Controls_Manager::TAB_STYLE,
      ]
        );     

        $this->add_control(
          'layout_style',
          [
              'label'     =>esc_html__( 'Layout style', 'wesper' ),
              'type'      => Controls_Manager::SELECT,
              'default'   => 'large_layout1',
              'options'   => [
                      'large_layout1'      =>esc_html__( 'Layout 1', 'wesper' ),
                      'large_layout2'      =>esc_html__( 'Layout 2', 'wesper' ),
                      'large_layout3'      =>esc_html__( 'Layout 3', 'wesper' ),
                      'large_layout4'      =>esc_html__( 'Layout 4', 'wesper' ),
                      'large_layout5'      =>esc_html__( 'Layout 5', 'wesper' ),
                  ],
          ]
      ); 
 
      $this->add_control(
        'jl_cus_img',
        [
            'label'     =>esc_html__( 'Image size', 'wesper' ),
            'type'      => Controls_Manager::SELECT,
            'default'   => '',
            'options'   => [
                    ''      =>esc_html__( 'Default image size', 'wesper' ),      
                    'wesper_large'      =>esc_html__( '1600 x 0', 'wesper' ),
                    'wesper_medium'      =>esc_html__( '1100 x 0', 'wesper' ),
                    'wesper_small'      =>esc_html__( '150 x 150', 'wesper' ),
                    'wesper_layouts'      =>esc_html__( '680 x 580', 'wesper' ),
                    'wesper_list'      =>esc_html__( '600 x 0', 'wesper' ),
                ],
        ]
    ); 
    
    $this->add_responsive_control(
      'jl_img5_width',
      [
          'label' => __( 'Image width', 'wesper' ),
          'type' => Controls_Manager::SLIDER,          
          'range' => [
              'px' => [
                  'min' => 1,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [            
          '{{WRAPPER}} .jl_lg_l5 .jl_img_holder' => 'flex: 0 0 {{SIZE}}%; max-width: {{SIZE}}%; width: {{SIZE}}%;',
          ],
        'condition' => [
          'layout_style'    => ['large_layout5']
        ]
      ]
    );
    
    $this->add_responsive_control(
        'jl_item_img_space',
        [
            'label' => __( 'Image height', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 60,
            ],
            'tablet_default' => [
              'size' => 60,
            ],
            'mobile_default' => [
              'size' => 60,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_lg_opt' => '--jl-img-space: {{SIZE}}%;',
            ],
        ]
      );    

      $this->add_responsive_control(
        'jl_cap_width',
        [
            'label' => __( 'Captions width', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 80,
            ],
            'tablet_default' => [
              'size' => 80,
            ],
            'mobile_default' => [
              'size' => 100,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 100,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_lg_opt' => '--jl-cap-w: {{SIZE}}%;',
            ],
        ]
      );    

        $this->add_responsive_control(
        'jl_item_row_space',
        [
            'label' => __( 'Row space', 'wesper' ),
            'type' => Controls_Manager::SLIDER,                        
            'default' => [
            'size' => 80,
            ],
            'tablet_default' => [
              'size' => 40,
            ],
            'mobile_default' => [
              'size' => 40,
            ],
            'range' => [
                'px' => [
                    'min' => 0,
                    'max' => 500,
                    'step' => 1,
                ]
            ],
            'selectors' => [            
            '{{WRAPPER}} .jl_lg_opt' => '--jlrow-gap: {{SIZE}}{{UNIT}} !important;',            
            ],
        ]
      );

      $this->add_responsive_control(
        'g_font_size',
        [
            'label' => __( 'Title font size', 'wesper' ),
            'type' => Controls_Manager::SLIDER,
            'default' => [
                'size' => 35,
            ],
            'tablet_default' => [
              'size' => 30,
            ],
            'mobile_default' => [
              'size' => 23,
            ],
            'range' => [
                'px' => [
                    'min' => 1,
                    'max' => 200,
                    'step' => 1,
                ]
            ],
            'selectors' => [
            '{{WRAPPER}} .jl_lg_opt' => '--jl-title-size: {{SIZE}}{{UNIT}} !important;',
            ],
        ]
    );    

    $this->add_responsive_control(
      'l_bg_top_space',
      [
          'label' => __( 'Background top space', 'wesper' ),
          'type' => Controls_Manager::SLIDER,          
          'range' => [
              'px' => [
                  'min' => 1,
                  'max' => 300,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_lg_opt' => '--jl-background-space: -{{SIZE}}{{UNIT}} !important;',
          ],
          'condition' => [
            'layout_style'    => ['large_layout2']
          ]
      ]
  );    

  $this->add_responsive_control(
    'l_bg_right_space',
    [
        'label' => __( 'Background right space', 'wesper' ),
        'type' => Controls_Manager::SLIDER,          
        'range' => [
            'px' => [
                'min' => 1,
                'max' => 300,
                'step' => 1,
            ]
        ],
        'selectors' => [
        '{{WRAPPER}} .jl_lg_opt' => '--jl-backgroundright-space: -{{SIZE}}{{UNIT}} !important;',
        ],
        'condition' => [
          'layout_style'    => ['large_layout4']
        ]
    ]
);

$this->add_control(
  'jl_cap_on_right',
  [
      'label' => esc_html__( 'Caption text on left', 'wesper' ),
      'type' => Controls_Manager::SWITCHER,    
      'selectors' => [
        '{{WRAPPER}} .jl_lg_l5 .jl_lg_op_in' => 'flex-direction: row-reverse',
      ],
      'condition' => [
        'layout_style'    => ['large_layout5']
      ]
  ]
);

$this->add_control(
  'title5_bg',
  [
    'label' => __( 'Caption background', 'wesper' ),
    'type' => Controls_Manager::COLOR,        
    'default' => '#eeebd9',
    'selectors' => [
        '{{WRAPPER}} .jl_lg_l5 .jl_lg_op_in' => 'background: {{VALUE}}',
    ],
    'condition' => [
        'layout_style'    => ['large_layout5']
    ]
  ]
);

$this->add_control(
  'title5_bg_dark',
  [
    'label' => __( 'Caption background dark mode', 'wesper' ),
    'type' => Controls_Manager::COLOR,        
    'default' => '#2e2e2a',
    'selectors' => [
        '.options_dark_skin {{WRAPPER}} .jl_lg_l5 .jl_lg_op_in' => 'background: {{VALUE}}',
    ],
    'condition' => [
        'layout_style'    => ['large_layout5']
    ]
  ]
);

$this->add_control(
  'title5_color',
  [
    'label' => __( 'Caption color', 'wesper' ),
    'type' => Controls_Manager::COLOR,        
    'selectors' => [
        '{{WRAPPER}} .jl_fe_title a, {{WRAPPER}} .jl_f_cat .jl_cat_txt, {{WRAPPER}} .jl_post_meta span, {{WRAPPER}} .jl_post_meta span a, {{WRAPPER}} .jl_fe_des' => 'color: {{VALUE}} !important',
    ]
  ]
);

$this->add_control(
  'title5_color_dark',
  [
    'label' => __( 'Caption color dark mode', 'wesper' ),
    'type' => Controls_Manager::COLOR,        
    'selectors' => [
        '.options_dark_skin {{WRAPPER}} .jl_fe_title a, .options_dark_skin {{WRAPPER}} .jl_f_cat .jl_cat_txt, .options_dark_skin {{WRAPPER}} .jl_post_meta span, .options_dark_skin {{WRAPPER}} .jl_post_meta span a, .options_dark_skin {{WRAPPER}} .jl_fe_des' => 'color: {{VALUE}} !important',
    ]
  ]
);

$this->add_responsive_control(
  'title5_padding',
  [
      'label'      => __( 'Padding caption', 'wesper' ),
      'type'       => Controls_Manager::DIMENSIONS,
      'size_units' => [ 'px', '%'],
          'default'    => [
              'top'      => '0',
              'right'    => '30',
              'bottom'   => '0',
              'left'     => '30',
              'unit'     => 'px',
              'isLinked' => false
          ],
      'selectors'  => [
          '{{WRAPPER}} .jl_lg_l5 .jl_lg_op_in .jl_fe_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
      ],
      'condition' => [
          'layout_style'    => ['large_layout5']
      ]
  ]
);
  
    
    $this->add_control(
      'titlebg',
      [
        'label' => __( 'Title bg color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '{{WRAPPER}} .jl_lg_l2 .jl_lg_op_in .jl_fe_text' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout2']
        ]
      ]
    );

    $this->add_control(
      'titlebg_dark',
      [
        'label' => __( 'Title bg color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#101010',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_lg_l2 .jl_lg_op_in .jl_fe_text' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout2']
        ]
      ]
    );

    $this->add_control(
      'btn_line',
      [
        'label' => __( 'Button line color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn' => 'border-color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_line_dark',
      [
        'label' => __( 'Button line color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#101010',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn' => 'border-color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_color',
      [
        'label' => __( 'Button text color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn' => 'color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_color_dark',
      [
        'label' => __( 'Button text color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn' => 'color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_hbg',
      [
        'label' => __( 'Button bg hover color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '{{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn:hover' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_hbg_dark',
      [
        'label' => __( 'Button bg hover color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#000',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn:hover' => 'background: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_hcolor',
      [
        'label' => __( 'Button hover color', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '{{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn:hover' => 'color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_control(
      'btn_hcolor_dark',
      [
        'label' => __( 'Button hover color dark mode', 'wesper' ),
        'type' => Controls_Manager::COLOR,        
        'default' => '#FFF',
        'selectors' => [
            '.options_dark_skin {{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn:hover' => 'color: {{VALUE}}',            
        ],
        'condition' => [
          'layout_style'    => ['large_layout3']
        ]
      ]
    );

    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
          'name' => 'button_typography', 
          'label' =>esc_html__( 'Button typography', 'wesper' ),               
          'selector' => '{{WRAPPER}} .jl_lg_l3 .jl_fe_text.jl_fe_txt_bot .jl_cap_btn',
          'condition' => [
            'layout_style'    => ['large_layout3']
          ]
      ]
  );

    $this->add_responsive_control(
      'jl_text_align',
      array(
          'label'     => __( 'Text alignment', 'wesper' ),
          'type'      => Controls_Manager::CHOOSE,
          'options'   => array(
              'left'   => array(
                  'title' => __( 'Left', 'wesper' ),
                  'icon'  => 'eicon-text-align-left',
              ),
              'center' => array(
                  'title' => __( 'Center', 'wesper' ),
                  'icon'  => 'eicon-text-align-center',
              ),
              'right'  => array(
                  'title' => __( 'Right', 'wesper' ),
                  'icon'  => 'eicon-text-align-right',
              ),
          ),
          'toggle'    => false,
          'selectors' => array(
              '{{WRAPPER}} .jl_lg_opt' => '--jl-algin-h: {{VALUE}};',
          )                
      )
  );

    $this->add_responsive_control(
      'g_pagination',
      [
          'label' => __( 'Pagination spacing', 'wesper' ),
          'type' => Controls_Manager::SLIDER,            
          'range' => [
              'px' => [
                  'min' => -150,
                  'max' => 400,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_el_nav_w' => 'margin-top: {{SIZE}}{{UNIT}};',            
          ],
      ]
  ); 

  $this->add_responsive_control(
      'g_pagination_radius',
      [
          'label' => __( 'Pagination broder radius', 'wesper' ),
          'type' => Controls_Manager::SLIDER,            
          'range' => [
              'px' => [
                  'min' => 0,
                  'max' => 200,
                  'step' => 1,
              ]
          ],
          'selectors' => [
          '{{WRAPPER}} .jl_lmore_c' => 'border-radius: {{SIZE}}{{UNIT}};',
          ],
      ]
  );        

  $this->add_responsive_control(
          'jlc_align',
          array(
              'label'     => __( 'Pagination alignment', 'wesper' ),
              'type'      => Controls_Manager::CHOOSE,
              'options'   => array(
                  'left'   => array(
                      'title' => __( 'Left', 'wesper' ),
                      'icon'  => 'eicon-text-align-left',
                  ),
                  'center' => array(
                      'title' => __( 'Center', 'wesper' ),
                      'icon'  => 'eicon-text-align-center',
                  ),
                  'flex-end'  => array(
                      'title' => __( 'Right', 'wesper' ),
                      'icon'  => 'eicon-text-align-right',
                  ),
              ),
              'toggle'    => false,
              'selectors' => array(
                  '{{WRAPPER}} .jl_el_nav_w' => 'justify-content: {{VALUE}};',
              )                
          )
      );

  $this->add_control(
              'jl_hide_cat',
              [
                  'label' => esc_html__( 'Hide category', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          ); 

          $this->add_control(
              'jl_hide_author',
              [
                  'label' => esc_html__( 'Hide author', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          ); 

          $this->add_control(
              'jl_hide_date',
              [
                  'label' => esc_html__( 'Hide date', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          );   

          $this->add_control(
              'jl_hide_meta',
              [
                  'label' => esc_html__( 'Hide author & date', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          );
          
          $this->add_control(
              'jl_hide_desc',
              [
                  'label' => esc_html__( 'Hide description', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          ); 

          $this->add_control(
              'jl_hide_review',
              [
                  'label' => esc_html__( 'Hide review', 'wesper' ),
                  'type' => Controls_Manager::SWITCHER,
                  'return_value' => 'yes',
                  'default' => 'no',
              ]
          ); 

          $this->add_control(
            'jl_hide_line',
            [
                'label' => esc_html__( 'Hide row line', 'wesper' ),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        ); 
         
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings();

      if ( function_exists( 'wesper_lgrid' ) ) {
      $settings['blockid'] = 'blockid_' . $this->get_id();      
      if(!empty($settings['categories'])){
      $settings['categories'] = implode(',', $settings['categories']);      
      }
      
      // if(isset($settings['author']) && is_array($settings['author']) ? $settings['author'] : []){
      //   $author = isset($settings['author']) && is_array($settings['author']) ? $settings['author'] : [];
      //   $settings['author'] = implode(',', $author);      
      // }else{
      //   $settings['author'] = $settings['author'];
      // }

      echo \wesper_lgrid( $settings );
      }
    }

    public function post_categories() {

      $terms = get_terms( array(
            'taxonomy'    => 'category',
            'hide_empty'  => false,
            'posts_per_page' => -1, 
            'suppress_filters' => false,
      ) );

      $cat_list = [];
      foreach($terms as $post) {
      $cat_list[$post->term_id]  = [$post->name];
      }
      return $cat_list;
   }

   public function post_author() {

    $blogusers = get_users( array(
    'role__not_in' => array( 'subscriber' ),
    'fields'       => array( 'ID', 'display_name' )
    ) );

      $user_list = [];
      $user_list['none']= esc_html__( 'None', 'wesper' );
      foreach($blogusers as $user) {
      $user_list[$user->ID]  = [$user->display_name];
      }
      return $user_list;
   }

   public function post_get_type() {

    $post_types = get_post_types( '', 'names' ); 

      $type_list = [];
      $type_list['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $post_types ) ){
        foreach($post_types as $p_type) {
        $type_list[$p_type]  = [$p_type];
        }
      }
      return $type_list;
   }

   public function post_get_taxs() {

    $taxonomies = get_taxonomies();

      $type_taxs = [];
      $type_taxs['none']= esc_html__( 'None', 'wesper' );
      if ( ! empty( $taxonomies ) ){
        foreach($taxonomies as $p_taxs) {
        $type_taxs[$p_taxs]  = [$p_taxs];
        }
    }
      return $type_taxs;
   }

}