<?php
define( 'WESPER_VERSION', '1.1.1' );
load_theme_textdomain('wesper', get_template_directory() . '/langs');
add_action( 'after_setup_theme', 'wesper_theme_setup', 1 );
if ( ! function_exists( 'wesper_theme_setup' ) ) {
  function wesper_theme_setup() {
    if ( ! isset( $GLOBALS['content_width'] ) ) {
      $GLOBALS['content_width'] = 1200;
    }
    add_theme_support( 'wc-product-gallery-zoom' );    
    add_theme_support( 'wc-product-gallery-slider' );
    add_theme_support( 'post-formats', array('gallery', 'quote', 'video', 'audio') );
    add_theme_support( 'automatic-feed-links' );
    add_theme_support('bbpress');
    add_theme_support( "title-tag" );
    add_theme_support('post-thumbnails');
    add_theme_support( 'align-wide' );
    add_theme_support( 'wp-block-styles' );
    add_theme_support( 'editor-styles' );
    add_theme_support( 'responsive-embeds' );
    add_theme_support(
      'html5',
        array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
            'script',
            'style'
        )
    );    
  }
}

add_action( 'init', 'wesper_image_size' );
if ( !function_exists( 'wesper_image_size' ) ) {
	function wesper_image_size() {
    add_image_size('wesper_large', 1600, 0, false);
    add_image_size('wesper_medium', 1100, 0, false);
    add_image_size('wesper_small', 150, 150, true);
    add_image_size('wesper_layouts', 680, 580, true);
    add_image_size('wesper_list', 600, 0, false);
    add_image_size('wesper_large_sload', 20, 0, false);
    add_image_size('wesper_medium_sload', 20, 0, false);
    add_image_size('wesper_small_sload', 20, 20, true);
    add_image_size('wesper_layouts_sload', 20, 15, true);
    add_image_size('wesper_list_sload', 20, 0, false);
  }
}

add_action('init', 'wesper_register_menu');
if ( !function_exists( 'wesper_register_menu' ) ) {
  function wesper_register_menu() {
    register_nav_menus(
        array(
          'main_menu' => esc_html__('Main menu', 'wesper'),
          'mobile_menu' => esc_html__('Mobile main menu', 'wesper'),
        )
    );
    $header_layout= get_theme_mod('header_layout_design','header_3');
    if( $header_layout == 'header_3' || $header_layout == 'header_4' || $header_layout == 'header_5' || $header_layout == 'header_6' || $header_layout == 'header_7' || $header_layout == 'header_8' || $header_layout == 'header_9'){
      register_nav_menus(
        array(
          'top_menu' => esc_html__('Top menu', 'wesper'),
        )
      );
    }
    $sub_footer = get_theme_mod('sub_footer', 'sub_footer0');
    if( $sub_footer == 'sub_footer1' || $sub_footer == 'sub_footer3' || $sub_footer == 'sub_footer5' ){
        register_nav_menus(
          array(
            'footer_menu' => esc_html__('Footer menu', 'wesper')
          )
        );
    }
  }
}

add_action( 'wp_ajax_ajax_action', 'wesper_day_night');
add_action( 'wp_ajax_nopriv_ajax_action', 'wesper_day_night' );
if ( !function_exists( 'wesper_day_night' ) ) {
    function wesper_day_night() {
        $jl_dn_option = isset( $_COOKIE['jlmode_dn'] ) ? $_COOKIE['jlmode_dn'] : '';
        if ( 'true' === $jl_dn_option ){
            return 'options_dark_skin';
        }
    }
}

add_filter( 'body_class','wesper_body_classes' );
if ( !function_exists( 'wesper_body_classes' ) ) {
  function wesper_body_classes( $classes ) {
      $jl_dn_option = isset( $_COOKIE['jlmode_dn'] ) ? $_COOKIE['jlmode_dn'] : '';
      $jl_header_tp = get_post_meta( get_the_ID(), 'jl_header_tp', true );
      $single_post_layout = get_post_meta( get_the_ID(), 'single_post_layout', true );
      $single_post_layout_options = get_theme_mod('single_post_layout_options','single1');
      $title_link = get_theme_mod('wesper_title_link','jl_tline');      
      $title_link = get_theme_mod('wesper_title_link','jl_tline');
      $post_sidebar_opt = get_theme_mod('post_sidebar_position','jl_sright_side');
      $post_sidebar_meta = get_post_meta( get_the_ID(), 'post_sidebar_position', true );
      $footer_logo = get_theme_mod('footer_logo','logo_foot_white');
      $sticky_logo = get_theme_mod('sticky_logo','logo_sticky_normal');
      $wesper_widget_font = get_theme_mod('wesper_widget_font','jl_weg_title');
      $mb_nav_left = get_theme_mod('mb_nav_left');
      $mb_nav_right = get_theme_mod('mb_nav_right');
      $post_sidebar = get_theme_mod('post_sidebar','default');
      $page_sidebar = get_theme_mod('page_sidebar','default');
      $category_sidebar = get_theme_mod('category_sidebar','default');
      $tag_sidebar = get_theme_mod('tag_sidebar','default');
      $archive_sidebar = get_theme_mod('archive_sidebar','default');
      $author_sidebar = get_theme_mod('author_sidebar','default');
      $search_sidebar = get_theme_mod('search_sidebar','default');
      if(!empty(get_theme_mod('jl_search_layout'))){
        $classes[] = 'jlac_smseah';
      }
      if(!empty($single_post_layout)){
        $classes[] = 'jl_spop_'.$single_post_layout;
      }else{
        $classes[] = 'jl_spop_'.$single_post_layout_options;
      }      
      if(!empty(get_theme_mod('single_left_share_style'))){
        $classes[] = get_theme_mod('single_left_share_style');
      }
      if(!empty($mb_nav_left)){
        $classes[] = 'jl_mb_nav_pos_left';
      }
      if(!empty($mb_nav_right)){
        $classes[] = 'jl_mb_nav_pos_right';
      }
      $classes[] = $footer_logo;
      $classes[] = $sticky_logo;
      $classes[] = $wesper_widget_font;
      if(empty($post_sidebar_meta)){
        $classes[] = $post_sidebar_opt;
      }else{
        $classes[] = $post_sidebar_meta;
      }
      $classes[] = 'jl_nav_stick jl_nav_active jl_nav_slide mobile_nav_class is-lazyload';
      $classes[] = wesper_day_night();
      if ($jl_dn_option !='false') {
        if(get_theme_mod('enable_dark_skin')){
        $classes[] = 'options_dark_skin jl_en_day_night';
        }else{
        $classes[] = ' jl_en_day_night';
        }
      }else{
        $classes[] = ' jl_en_day_night';
      }      
      if($category_sidebar == "default" || $tag_sidebar == "default" || $archive_sidebar == "default" || $author_sidebar == "default" || $search_sidebar == "default"){
        if (is_active_sidebar('general-sidebar')) {
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_category() ) {
        if($category_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_tag() ) {
        if($tag_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_search() ) {
        if($search_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_tax() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_date() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_home() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_post_type_archive() ) {
        if($archive_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }
      if ( is_author() ) {
        if($author_sidebar != "default"){
          $classes[] = 'jl-has-sidebar';
        }
      }

      if ($title_link == 'jl_tline'){
        $classes[] = 'jl_tline';
      }elseif($title_link == 'jl_uline'){
        $classes[] = 'jl_uline';
      }else{
        $classes[] = 'jl_tcolor';
      }
      if ($jl_header_tp == 'on'){
        $classes[] = 'jl_header_tp';
      }
      if ( get_theme_mod('header_layout_design') == '' ){
        $classes[] = get_theme_mod('header_layout_design');
      }
      if ( get_theme_mod('sticky_header') ){
        $classes[] = get_theme_mod('sticky_header');
      }      
      return $classes;
  }
}

add_filter('nav_menu_item_id', 'wesper_my_css_attributes_filter', 100, 1);
if ( !function_exists( 'wesper_my_css_attributes_filter' ) ) {
  function wesper_my_css_attributes_filter($var) {
    return is_array($var) ? array() : '';
  }
}

add_filter('wp_list_categories', 'wesper_cat_count_span');
if ( !function_exists( 'wesper_cat_count_span' ) ) {
  function wesper_cat_count_span($links) {
    $links = str_replace('</a> (', '<span>', $links);
    $links = str_replace(')', '</span></a>', $links);
    return $links;
  }
}

add_filter( 'get_archives_link', 'wesper_archives_count_span' );
if ( !function_exists( 'wesper_archives_count_span' ) ) {
  function wesper_archives_count_span($links) {
    $links = str_replace( '</a>&nbsp;(', '<span>', $links );
    $links = str_replace(')', '</span></a>', $links);
    return $links;
  }
}

add_action('widgets_init', 'wesper_sidebar_register');
if ( !function_exists( 'wesper_sidebar_register' ) ) {
  function wesper_sidebar_register() {
      register_sidebar(array(
          'name' => esc_html__('General Sidebar', 'wesper'),
          'id' => 'general-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => '</div>',
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Mobile Section Sidebar', 'wesper'),
          'id' => 'mobile-menu-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => '</div>',
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
        'name' => esc_html__('Header Section Sidebar', 'wesper'),
        'id' => 'header-sidebar',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
        'after_title' => '</h2></div>',
    ));
      register_sidebar(array(
          'name' => esc_html__('First Footer Sidebar', 'wesper'),
          'id' => 'footer1-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Second Footer Sidebar', 'wesper'),
          'id' => 'footer2-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Third Footer Sidebar', 'wesper'),
          'id' => 'footer3-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      register_sidebar(array(
          'name' => esc_html__('Fourth Footer Sidebar', 'wesper'),
          'id' => 'footer4-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));

      if ( class_exists( 'woocommerce' ) ) {
        register_sidebar(array(
          'name' => esc_html__('Shop Sidebar', 'wesper'),
          'id' => 'woos-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));
      }

      if ( class_exists('bbPress', false) ) {
        register_sidebar(array(
          'name' => esc_html__('bbPress Sidebar', 'wesper'),
          'id' => 'bbpress-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));        
      }

      if ( class_exists( 'Buddypress', false ) ) {
        register_sidebar(array(
          'name' => esc_html__('BuddyPress Sidebar', 'wesper'),
          'id' => 'bdpress-sidebar',
          'before_widget' => '<div id="%1$s" class="widget %2$s">',
          'after_widget' => "</div>",
          'before_title' => '<div class="widget-title"><h2 class="jl_title_c">',
          'after_title' => '</h2></div>',
      ));        
      }

  }
}

if ( !function_exists( 'wesper_post_type' ) ) {
  function wesper_post_type(){
      if(has_post_format( 'video')){
          if (empty($videourl)){
            $post_type_image = '<span class="jl_post_type_icon"></span>';
          }
      }else{
          $post_type_image = '';
      }
      return $post_type_image;
  }
}

if(!function_exists('wesper_esc_data')){
  function wesper_esc_data() {
    $allowed_tags =
        array(
          'a' => array(
            'href' => array(),
            'title' => array(),
            'class' => array(),
            'data' => array(),
            'data-style' => array(),
            'rel'   => array()
          ),
          'div' => array(
            'class' => array(),
            'data' => array(),
            'data-style' => array()
          ),
          'span' => array(
            'class' => array(),
            'data' => array(),
            'data-style' => array()
          ),
          'iframe' => array(
            'src' => array(),
            'class' => array(),
            'data' => array(),
            'data-style' => array(),
            'allow' => array(),
            'allowfullscreen' => array(),
            'width' => array(),
            'height' => array(),
            'frameborder' => array()
          )
    );
    return $allowed_tags;
  }
}

if ( !function_exists( 'wesper_post_meta' ) ) {
  function wesper_post_meta() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="jl_post_meta">';
  		if(get_theme_mod('hide_front_author') !=1){
        if( !empty( get_theme_mod('show_author_img' ) ) ){
          echo '<span class="jl_author_img_w">';
          echo '<span class="jl_aimg_in">';
          echo get_avatar(get_the_author_meta('ID'), 50, '', '', array( 'class' => 'lazyload' ));
          echo '</span>';
          echo the_author_posts_link();
          echo '</span>';
        }else{
          echo '<span class="jl_author_img_w">';
          echo wespertxt::wesper_s_by();
          echo the_author_posts_link();
          echo '</span>';
        }
      }
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
  		echo'</span>';
    }
  }
}

if(!function_exists('wesper_author_date_meta')){
  function wesper_author_date_meta() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="jl_post_meta">';
  		if(get_theme_mod('hide_front_author') !=1){
        echo '<span class="jl_author_img_w">';
        echo wespertxt::wesper_s_by();
        echo the_author_posts_link();
        echo '</span>';
      }
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
  		echo'</span>';
    }
  }
}

if(!function_exists('wesper_post_meta_date')){
  function wesper_post_meta_date() {
    if(get_theme_mod('hide_front_author_date') !=1){
      echo '<span class="jl_post_meta">';
      if(get_theme_mod('hide_front_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
      echo'</span>';
    }
  }
}

if(!function_exists('wesper_post_ov_cat')){
  function wesper_post_ov_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_overlay', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('wesper_post_list_cat')){
  function wesper_post_list_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_list', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('wesper_post_small_cat')){
  function wesper_post_small_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_small_list', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;      
      case 'cat_label_3' :
        if ($categories) {
              echo '<span class="jl_f_cat jl_lb3">';
              foreach( $categories as $tag) {
                $tag_link = get_category_link($tag->term_id);
               echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
              }
              echo "</span>";
              }
        break;            
      }
    }
  }
}

if(!function_exists('wesper_post_tumb_cat')){
  function wesper_post_tumb_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_grid','cat_label_1');
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
			case 'cat_label_4' :
			if ($categories) {
            echo '<span class="jl_f_cat jl_lb4">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;
      case 'cat_label_5' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb5">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_6' :
        if ($categories) {
              echo '<span class="jl_f_cat jl_lb6">';
              foreach( $categories as $tag) {
                $tag_link = get_category_link($tag->term_id);
                echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
              }
              echo "</span>";
              }
        break;
        case 'cat_label_7' :
          if ($categories) {
                echo '<span class="jl_f_cat jl_lb7">';
                foreach( $categories as $tag) {
                  $tag_link = get_category_link($tag->term_id);
                  echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
                }
                echo "</span>";
                }
          break;
      }
    }
  }
}

if(!function_exists('wesper_post_cat')){
  function wesper_post_cat() {
    if(get_theme_mod('hide_front_cat') !=1){
      $cat_style = get_theme_mod('category_label_grid','cat_label_1');
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
			case 'cat_label_1' :
			if ($categories) {
            echo '<span class="jl_f_cat jl_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
			break;
			case 'cat_label_2' :
			if ($categories) {
            echo '<span class="jl_f_cat jl_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;
			case 'cat_label_3' :
			if ($categories) {
            echo '<span class="jl_f_cat jl_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
              echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
			break;	
      		      
      }
    }
  }
}

if ( !function_exists( 'wesper_single_meta_list' ) ) {
  function wesper_single_meta_list() {
    $enable_sponsored_post = get_post_meta( get_the_ID(), 'enable_sponsored_post', true );
    if(!empty($enable_sponsored_post)){
      wesper_sponsored();
    }else{
      echo '<span class="jl_post_meta jl_slimeta">';
  		if(get_theme_mod('disable_post_meta_author') !=1){
          echo '<span class="jl_author_img_w">';
          if(empty(get_theme_mod('disable_post_author_img'))){
            echo '<span class="jl_aimg_in">';
            echo get_avatar(get_the_author_meta('ID'), 50, '', '', array( 'class' => 'lazyload' ));
            echo '</span>';
          }else{
            echo wespertxt::wesper_s_by();
          }
          echo the_author_posts_link();
          echo '</span>';
      }
      if(get_theme_mod('disable_post_date') !=1){
        echo '<span class="post-date">'.get_the_date().'</span>';
      }
      if(get_theme_mod('disable_post_readtime') !=1){
        echo '<span class="post-read-time">'.wesper_read_time().'</span>';
      }
      if(get_theme_mod('disable_post_view') !=1){
        if(function_exists('wesper_bac_PostViews')){
        echo '<span class="jl_view_options">';        
        echo wesper_bac_PostViews(get_the_ID()).' '.wespertxt::wesper_s_views();        
        echo '</span>';
        }
      }
  		echo'</span>';
      if(!empty(get_theme_mod('disable_post_view'))){
        if(function_exists('wesper_bac_PostViews')){
        echo '<span class="jl_view_none">';        
        echo wesper_bac_PostViews(get_the_ID());        
        echo '</span>';
        }
      }
    }
  }
}

if(!function_exists('wesper_post_single_cat')){
  function wesper_post_single_cat() {
    if(get_theme_mod('disable_post_category') !=1){
      $cat_style = get_theme_mod('category_label_single', 'cat_label_1');      
      $categories = get_the_category(get_the_ID());
      switch ( $cat_style ) {
      case 'cat_label_1' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb1">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'"><span>'.esc_attr($tag->name).'</span></a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_2' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb2">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_txt jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;
      case 'cat_label_3' :
      if ($categories) {
            echo '<span class="jl_f_cat jl_lb3">';
            foreach( $categories as $tag) {
              $tag_link = get_category_link($tag->term_id);
             echo '<a class="jl_cat_lbl jl_cat'.esc_attr($tag->term_id).'" href="'.esc_url($tag_link).'">'.esc_attr($tag->name).'</a>';
            }
            echo "</span>";
            }
      break;            
      }
    }
  }
}

if(!function_exists('wesper_post_sidebar')){
  function wesper_post_sidebar() {
      $sidebar_post_options = get_post_meta(get_the_ID(), 'single_post_sidebar', true);
      if(isset($sidebar_post_options)){
  		    $custom_sidebar = $sidebar_post_options;
  				$post_sidebar = get_theme_mod('post_sidebar');
  				if(!empty($post_sidebar)) {
  						$custom_sidebar = $post_sidebar;
  				}
  				global $wp_registered_sidebars;
  				foreach ( $wp_registered_sidebars as $sidebar ) {
    				if($sidebar['id'] == $custom_sidebar){
    							 $dyn_side = $sidebar['id'];
    				}
  				}
  		}
  		if(isset($dyn_side)) {
  					if (is_active_sidebar($dyn_side)) { dynamic_sidebar($dyn_side);}
  		} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar'); }
  		}
  }
}

if(!function_exists('wesper_page_sidebar')){
  function wesper_page_sidebar() {
  	   $sidebar_page_options = get_post_meta(get_the_ID(), 'single_page_sidebar', true);
  	   if(isset($sidebar_page_options)){
  			   $custom_sidebar = $sidebar_page_options;
  				$page_sidebar = get_theme_mod('page_sidebar');
  					if(!empty($page_sidebar)) {
  						$custom_sidebar = $page_sidebar;
  					}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $dyn_side = $sidebar['id'];
  						}
  					}
  			}
  			if(isset($dyn_side)) {
  					if (is_active_sidebar($dyn_side)) { dynamic_sidebar($dyn_side);}
  			} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar'); }
  			}
  }
}

if(!function_exists('wesper_category_sidebar')){
  function wesper_category_sidebar() {
        $category_sidebar = get_theme_mod('category_sidebar','default');
  			$custom_sidebar ='';
  				if(!empty($category_sidebar)) {	$custom_sidebar = $category_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('wesper_tag_sidebar')){
  function wesper_tag_sidebar() {
  $tag_sidebar = get_theme_mod('tag_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($tag_sidebar)) {	$custom_sidebar = $tag_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('wesper_archive_sidebar')){
  function wesper_archive_sidebar() {
  $archive_sidebar = get_theme_mod('archive_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($archive_sidebar)) {	$custom_sidebar = $archive_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('wesper_author_sidebar')){
  function wesper_author_sidebar() {
  $author_sidebar = get_theme_mod('author_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($author_sidebar)) {	$custom_sidebar = $author_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('wesper_search_sidebar')){
  function wesper_search_sidebar() {
  $search_sidebar = get_theme_mod('search_sidebar','default');
  				$custom_sidebar ='';
  				if(!empty($search_sidebar)) {	$custom_sidebar = $search_sidebar;	}
  					global $wp_registered_sidebars;
  					foreach ( $wp_registered_sidebars as $sidebar ) {
  					if($sidebar['name'] == $custom_sidebar){
  							 $custom_sidebar = $sidebar['id'];
  						}
  				}
  				if(!empty($custom_sidebar) && $custom_sidebar !='default') {
  					if (is_active_sidebar($custom_sidebar)) { dynamic_sidebar($custom_sidebar);}
  				} else{
  					if (is_active_sidebar('general-sidebar')) { dynamic_sidebar('general-sidebar');}
  				}
  }
}

if(!function_exists('wesper_read_time')){
  function wesper_read_time($postid = '') {
    if($postid == '') {
      $postid = get_the_ID();
    }
    $content = get_post_field( 'post_content', $postid );
    $post_words_count = str_word_count( strip_tags( $content ) );
    $readtime = round($post_words_count / 265);
    if($readtime < 1) {
      $readtime = 1;
    }
    $readtime_html = $readtime.' '.wespertxt::wesper_s_mins_read();
    return $readtime_html;
  }
}

if ( ! function_exists( 'wesper_comment_heading' ) ) {
	function wesper_comment_heading( $post_id = '' ) {
		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}
		$output = wespertxt::wesper_s_leave_a_comment();
		$count  = intval( get_comments_number( $post_id ) );

		if ( $count > 1 ) {
			$output = sprintf( wespertxt::wesper_s_comments(), $count );
		} elseif ( 1 === $count ) {
			$output = wespertxt::wesper_s_comment();
		}
		return $output;
	}
}
if ( ! function_exists( 'wesper_comment' ) ) {
	function wesper_comment( ) {
    if( !empty(get_theme_mod('disable_section_comment')) ){
			return false;
		}
    if ( post_password_required() ) {
			return false;
		}
    if ( comments_open() || get_comments_number() ) {
		$class_name = 'jl_comment_wrap';
		if ( ! get_comments_number() ) {
			$class_name .= ' jl_no_comment';
		}
		?>
        <div class="single_section_comment">
          <?php if( empty(get_theme_mod('disable_section_comment_title')) ){?>
            <div class="jl_comment_head">
              <h3 class="jl_comment_head_title"><?php echo wesper_comment_heading( get_the_ID() ); ?></h3>
            </div>
            <?php }?>
            <div class="<?php echo esc_attr( $class_name ); ?>"><?php comments_template(); ?></div>
        </div>
		<?php
	  }
  }
}

add_filter( 'comment_form_defaults', 'wesper_comment_placeholder', 10 );
if ( ! function_exists( 'wesper_comment_placeholder' ) ) {
	function wesper_comment_placeholder( $defaults ) {
		if ( ! empty( $defaults['fields']['author'] ) ) {
			$defaults['fields']['author'] = str_replace( '<input', '<input placeholder="' . wespertxt::wesper_s_your_name() . '"', $defaults['fields']['author'] );
		}
		if ( ! empty( $defaults['fields']['email'] ) ) {
			$defaults['fields']['email'] = str_replace( '<input', '<input placeholder="' . wespertxt::wesper_s_your_email() . '"', $defaults['fields']['email'] );
		}
		if ( ! empty( $defaults['fields']['url'] ) ) {
			$defaults['fields']['url'] = str_replace( '<input', '<input placeholder="' . wespertxt::wesper_s_your_website() . '"', $defaults['fields']['url'] );
		}
		if ( ! empty( $defaults['comment_field'] ) ) {
			$defaults['comment_field'] = str_replace( '<textarea', '<textarea placeholder="' . wespertxt::wesper_s_leave_a_comment() . '"', $defaults['comment_field'] );
		}
		return $defaults;
	}
}

if ( ! function_exists( 'wesper_pagination' ) ) {
    function wesper_pagination( $wesper_qry = NULL ) {
        $wesper_pagination_type = 'numbered';
        $jl_archive_pagination = get_theme_mod('jl_archive_pagination', 'number');
        if ( is_category() ) {
                $wesper_cat_id = get_query_var('cat');                
        }
        if ( is_home() ) {}
        if ( is_tag() ) {}
        if ( $wesper_qry == NULL ) {
            global $wp_query;
            $wesper_total = $GLOBALS['wp_query']->max_num_pages;
            $wesper_paged = get_query_var('paged');
        } else {
            if ( is_page() ) {
                $wesper_total = $wesper_qry->max_num_pages;
                $wesper_pagination_type = 'n';
                $wesper_paged = get_query_var('page');
            } else {
                global $wp_query;
                $wesper_paged = get_query_var('paged');
                $wesper_total = $GLOBALS['wp_query']->max_num_pages;
            }
        }

              
      if ( is_search() ) {
        $wesper_pagination = paginate_links( array(
          'base'     => str_replace( 99999, '%#%', esc_url( get_pagenum_link(99999) ) ),
          'format'   => '',
          'total'    => $wesper_total,
          'current'  => max( 1, $wesper_paged ),
          'mid_size' => 2,
          'prev_text' => '<i class="jli-left-chevron"></i>',
          'next_text' => '<i class="jli-right-chevron"></i>',
          'type' => 'list',
        ) );
        echo '<nav class="jellywp_pagination">' . $wesper_pagination . '</nav>';
      }else{
        if ( $jl_archive_pagination == 'loadmore' ) {
          wesper_blocknav_loadmore( $wesper_qry );
        } elseif ( $jl_archive_pagination == 'autoload' ) {
          wesper_blocknav_autoload( $wesper_qry );
        }else {
            $wesper_pagination = paginate_links( array(
                'base'     => str_replace( 99999, '%#%', esc_url( get_pagenum_link(99999) ) ),
                'format'   => '',
                'total'    => $wesper_total,
                'current'  => max( 1, $wesper_paged ),
                'mid_size' => 2,
                'prev_text' => '<i class="jli-left-chevron"></i>',
                'next_text' => '<i class="jli-right-chevron"></i>',
                'type' => 'list',
            ) );
            echo '<nav class="jellywp_pagination">' . $wesper_pagination . '</nav>';
        }
      }
    }
}

if ( ! function_exists( 'wesper_get_qry' ) ) {
    function wesper_get_qry() {
      if ( is_home() ) {
        $wesper_paged = get_query_var('paged');
        if ( $wesper_paged == false ) {
          $wesper_paged = 1;
        }
        $wesper_offset_loop = NULL;
        $wesper_grid_size = NULL;
        $wesper_featured_qry = array('offset' => $wesper_grid_size, 'orderby' => 'date', 'order' => 'DESC',  'post_status' => 'publish', 'wesper_offset_loop' => $wesper_offset_loop, 'paged' => $wesper_paged );
        $wesper_qry = new WP_Query( $wesper_featured_qry );
      }elseif ( is_category() ) {
          $wesper_paged = get_query_var('paged');
          $wesper_grid_size = $wesper_current_cat = NULL;          
          if ( $wesper_paged == false ) {
              $wesper_paged = 1;
          }          
          $wesper_current_cat = get_query_var('cat');
          $wesper_grid_size = wesper_get_category_offset();          
          if ( $wesper_grid_size != NULL ) {
              $wesper_offset_loop = 'on';
          } else {
              $wesper_offset_loop = NULL;
          }
          $wesper_featured_qry = array( 'cat' => $wesper_current_cat, 'offset' => $wesper_grid_size, 'orderby' => 'date', 'order' => 'DESC',  'post_status' => 'publish', 'wesper_offset_loop' => $wesper_offset_loop, 'paged' => $wesper_paged );
          $wesper_qry = new WP_Query( $wesper_featured_qry );
      } elseif ( is_page() ) {
            $wesper_paged = get_query_var('page');
            $wesper_arr = NULL;
            if ( $wesper_paged == false ) {
                $wesper_paged = 1;
            }
            $wesper_page_id = get_the_ID();
            $wesper_hp_category_filter = 'off';
            $wesper_lb_offset = 'on';

            if ( $wesper_hp_category_filter == 'off' ) {
                $wesper_hp_category = '';
                foreach ( $wesper_hp_category as $wesper_cat ) {
                    $wesper_arr .= $wesper_cat . ',';
                }
                $wesper_arr = rtrim( $wesper_arr, ",");
            }
            if ( $wesper_lb_offset != NULL ) {
                $wesper_offset_loop = 'on';
            } else {
                $wesper_offset_loop = NULL;
            }
            $wesper_qry = new WP_Query( array('post_status' => 'publish', 'ignore_sticky_posts' => true, 'paged' => $wesper_paged, 'cat' => $wesper_arr, 'offset' => $wesper_lb_offset, 'wesper_offset_loop' => $wesper_offset_loop  ) );
        } else {
            global $wp_query;
            $wesper_qry = $wp_query;
        }
        return $wesper_qry;
    }
}

add_action( 'pre_get_posts', 'wesper_offset_loop_pre_get_posts' );
if ( ! function_exists( 'wesper_offset_loop_pre_get_posts' ) ) {
    function wesper_offset_loop_pre_get_posts( $query ){
        if ( isset( $query->query_vars['wesper_offset_loop'] ) && ( $query->query_vars['wesper_offset_loop'] == 'on' ) ) {
            if ( is_category() ) { $wesper_grid_size = wesper_get_category_offset(); }
            $wesper_posts_per_page = get_option('posts_per_page');
            if ( $query->is_paged == true ) {
                $wesper_page_offset = $wesper_grid_size + ( ( $query->query_vars['paged'] - 1 ) * $wesper_posts_per_page );
                $query->set( 'offset', $wesper_page_offset );
            } else {
                $query->set( 'offset', $wesper_grid_size );
            }
        }
         if ( ( is_category() || is_tag() || is_home() ) && $query->is_main_query() && ( ! is_admin() ) ) {
            $query->set( 'post_type', 'post' );
        }
        return $query;
    }
}

if ( ! function_exists( 'wesper_get_category_offset' ) ) {
    function wesper_get_category_offset() {
        $wesper_return = 0;
            $wesper_cat_id = get_query_var('cat');
            $wesper_offset = 'on';
            if ( $wesper_offset == 'on' || $wesper_offset == 'off' || $wesper_offset == '' ) {
                $wesper_grid_onoff = get_term_meta( $wesper_cat_id, 'wesper_cat_featured_op', true);
                if ($wesper_grid_onoff == 'style_1'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_2'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_3'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_4'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_5'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_6'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_7'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_8'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_9'){
                    $wesper_return = NULL;
                }elseif($wesper_grid_onoff == 'style_10'){
                    $wesper_return = NULL;
                }else{
                    $wesper_return = NULL;
                }
            }
        return $wesper_return;
    }
}

if ( ! function_exists( 'wesper_pagination_offset' ) ) {
    function wesper_pagination_offset($found_posts, $query) {
        $wesper_grid_size = 0;
        if ( is_category() ) { $wesper_grid_size = wesper_get_category_offset(); }
        if ( is_home() ) { $wesper_grid_size = 0; }
        if ( is_page() ) {
            $wesper_grid_size = 0;
        }
        return ( $found_posts - $wesper_grid_size );
    }
}
add_filter('found_posts', 'wesper_pagination_offset', 1, 2 );

include get_template_directory() . '/inc/misc/core.php';
include get_template_directory() . '/inc/misc/layout-grid.php';
include get_template_directory() . '/inc/misc/layout-grid-number.php';
include get_template_directory() . '/inc/misc/layout-list.php';
include get_template_directory() . '/inc/misc/layout-list-mix.php';
include get_template_directory() . '/inc/misc/layout-list-number.php';
include get_template_directory() . '/inc/misc/layout-small-list.php';
include get_template_directory() . '/inc/misc/layout-mini-list.php';
include get_template_directory() . '/inc/misc/layout-classic.php';
include get_template_directory() . '/inc/misc/layout-overlay.php';
include get_template_directory() . '/inc/misc/layout-slider.php';
include get_template_directory() . '/inc/misc/layout-slider-tab.php';
include get_template_directory() . '/inc/misc/layout-hover.php';
include get_template_directory() . '/inc/misc/layout-center-slider.php';
include get_template_directory() . '/inc/misc/layout-carousel.php';
include get_template_directory() . '/inc/misc/layout-featured-1.php';
include get_template_directory() . '/inc/misc/layout-featured-2.php';
include get_template_directory() . '/inc/misc/layout-featured-3.php';
include get_template_directory() . '/inc/misc/layout-featured-4.php';
include get_template_directory() . '/inc/misc/layout-featured-5.php';
include get_template_directory() . '/inc/misc/layout-featured-6.php';
include get_template_directory() . '/inc/misc/layout-featured-7.php';
include get_template_directory() . '/inc/misc/layout-featured-8.php';
include get_template_directory() . '/inc/misc/layout-featured-9.php';
include get_template_directory() . '/inc/misc/layout-featured-10.php';
include get_template_directory() . '/inc/misc/layout-featured-11.php';
include get_template_directory() . '/inc/misc/layout-featured-12.php';
include get_template_directory() . '/inc/misc/layout-featured-13.php';
include get_template_directory() . '/inc/misc/layout-featured-14.php';
include get_template_directory() . '/inc/misc/layout-featured-18.php';
include get_template_directory() . '/inc/misc/layout-featured-19.php';
include get_template_directory() . '/inc/misc/layout-featured-20.php';
include get_template_directory() . '/inc/misc/layout-marquee.php';
include get_template_directory() . '/inc/misc/layout-newsticker.php';
include get_template_directory() . '/inc/misc/layout-small-main-right-list.php';
include get_template_directory() . '/inc/misc/layout-small-main-below-2list.php';
include get_template_directory() . '/inc/misc/layout-small-main-below-list.php';
include get_template_directory() . '/inc/misc/layout-small-2main-below-list.php';
include get_template_directory() . '/inc/misc/layout-small-ov-main-below-list.php';
include get_template_directory() . '/inc/misc/layout-video.php';
include get_template_directory() . '/inc/misc/menu-p-layout.php';
include get_template_directory() . '/inc/misc/strings.php';
include get_template_directory() . '/inc/customizer/customizer.php';
include get_template_directory() . '/inc/functions/menu-option.php';
include get_template_directory() . '/inc/functions/class-tgm-plugin-activation.php';
include get_template_directory() . '/inc/functions/required-plugins.php';

if ( ! function_exists( 'wesper_fonts' ) ) {
  function wesper_fonts() {
  	  $google_font = '';
      $title_style_text = get_theme_mod('wesper_title_font_family', 'Inter Tight');
      $wesper_title_font_weight = get_theme_mod('wesper_title_font_weight', '800');
      if (strpos($title_style_text, 'jl_c_') !== false){
        $title_style_text = '';
      }else{
        $title_style_text = $title_style_text.':'.$wesper_title_font_weight.'|';
      }
      $paragrap_style_text = get_theme_mod('wesper_p_font_family', 'Inter');
      $wesper_p_font_weight = get_theme_mod('wesper_p_font_weight', '400');
      if (strpos($paragrap_style_text, 'jl_c_') !== false){
        $paragrap_style_text = '';
      }else{
        $paragrap_style_text = $paragrap_style_text.':'.$wesper_p_font_weight.'|';
      }
      $menu_font_style = get_theme_mod('wesper_menu_font_family', 'Inter Tight');
      $wesper_menu_font_weight = get_theme_mod('wesper_menu_font_weight', '700');
      $wesper_sub_menu_font_weight = ','.get_theme_mod('wesper_sub_menu_font_weight', '500');
      $cat_font_weight = get_theme_mod('wesper_cat_font_weight', '700');
      $wesper_meta_font_weight = get_theme_mod('wesper_meta_font_weight', '400');
      if (strpos($menu_font_style, 'jl_c_') !== false){
        $menu_font_style = '';
      }else{
        $menu_font_style = $menu_font_style.':'.$wesper_menu_font_weight.','.$wesper_sub_menu_font_weight.','.$cat_font_weight.','.$wesper_meta_font_weight.',';
      }
      if (strpos($title_style_text, 'jl_c_') !== false && strpos($paragrap_style_text, 'jl_c_') !== false && strpos($menu_font_style, 'jl_c_') !== false) {
        $google_font ='';
      }else{
        $google_font = add_query_arg( array(
           'family' => urlencode ( $title_style_text.$paragrap_style_text.$menu_font_style ),
           'display' => 'swap',
        ), '//fonts.googleapis.com/css' );
      }
      return esc_url_raw($google_font);
  }
}

add_action( 'wp_enqueue_scripts', 'wesper_font_scripts' );
if ( ! function_exists( 'wesper_font_scripts' ) ) {
  function wesper_font_scripts() {
    $title_style_text = get_theme_mod('wesper_title_font_family', 'Inter Tight');
    $paragrap_style_text = get_theme_mod('wesper_p_font_family', 'Inter');
    $menu_font_style = get_theme_mod('wesper_menu_font_family', 'Inter Tight');
    if (strpos($title_style_text, 'jl_c_') !== false && strpos($paragrap_style_text, 'jl_c_') !== false && strpos($menu_font_style, 'jl_c_') !== false) {
    }else{
      wp_enqueue_style( 'wesper_fonts_url', wesper_fonts(), array(), WESPER_VERSION );
    }
  }
}

add_action( 'enqueue_block_editor_assets', 'wesper_editor', 90 );
if ( ! function_exists( 'wesper_editor' ) ) {
  function wesper_editor() {
      wp_enqueue_style( 'wesper-editor-fonts', wesper_fonts(), array(), WESPER_VERSION );
      wp_enqueue_style( 'wesper-editor-style', get_template_directory_uri().'/css/editor.css', false, WESPER_VERSION );
      wp_add_inline_style( 'wesper-editor-style', wesper_editor_dynamic_css() );
  }
}

add_action( 'wp_enqueue_scripts', 'wesper_load_css' );
if ( ! function_exists( 'wesper_load_css' ) ) {
  function wesper_load_css() {
  		wp_enqueue_style( 'wesper_layout', get_template_directory_uri().'/css/layout.css', false, WESPER_VERSION );
      wp_enqueue_style( 'wesper_style', get_template_directory_uri().'/style.css', false, WESPER_VERSION );
      wp_enqueue_style( 'glightbox', get_template_directory_uri().'/css/glightbox.min.css', false, WESPER_VERSION );
      wp_enqueue_style( 'swiper', get_template_directory_uri().'/css/swiper.min.css', false, WESPER_VERSION );
      wp_add_inline_style( 'wesper_style', wesper_generate_dynamic_css() );
  }
}

add_action( 'wp_enqueue_scripts', 'wesper_enqueue_script' );
if ( ! function_exists( 'wesper_enqueue_script' ) ) {
  function wesper_enqueue_script() {
  	  wp_enqueue_script( 'swiper', get_template_directory_uri().'/js/swiper.min.js', array('jquery'), WESPER_VERSION, true );
      wp_enqueue_script( 'cookie', get_template_directory_uri().'/js/cookie.min.js', array('jquery'), WESPER_VERSION, true );
      wp_enqueue_script( 'lazysizes', get_template_directory_uri().'/js/lazysizes.min.js', array('jquery'), WESPER_VERSION, true );
      wp_enqueue_script( 'glightbox', get_template_directory_uri().'/js/glightbox.min.js', array('jquery'), WESPER_VERSION, true );
      wp_enqueue_script( 'wesper-custom', get_template_directory_uri().'/js/custom.js', array('jquery'), WESPER_VERSION, true );
      wp_localize_script( 'wesper-custom', 'jlParamsOpt',
      array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'opt_dark' => get_theme_mod('enable_dark_skin')                
      ));
  }
}
?>