<?php
if ( ! function_exists( 'wesper_mgrid' ) ) {
	function wesper_mgrid( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'jl_mgrid',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',
			'pagination'         => '',
			'show_excep'         => '',
			'tabs_link'       	 => '',
			'tabs_link_ids'   	 => '',
			'tabs_link_label' 	 => '',
			'jl_hide_cat'        => '',
			'jl_hide_author'     => '',
			'jl_hide_date'       => '',
			'jl_hide_meta'       => '',
			'jl_hide_desc'       => '',
			'jl_hide_review'     => '',
			'jl_hide_line'       => '',
			'jl_hide_col_line'   => '',
			'jl_cus_img'     => '',
			'ignore_sticky_posts' => '',
		), $attrs );
		$module['style_mian']     = 'jl-main-block';
		$module['row_style_mian'] = 'jl-col-row';
		$total_posts = $module['posts_per_page'];
		$query_data = wesper_query( $module );
		$show_excep = $module['show_excep'];
		$module['posts_per_page'] = $total_posts;
		$module['show_excep'] = $show_excep;		
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['jl_hide_cat'] ) {
			$atts_style[] = 'jl_hide_cat';
		}
		if ( 'yes' === $module['jl_hide_author'] ) {
			$atts_style[] = 'jl_hide_author';
		}
		if ( 'yes' === $module['jl_hide_date'] ) {
			$atts_style[] = 'jl_hide_date';
		}
		if ( 'yes' === $module['jl_hide_meta'] ) {
			$atts_style[] = 'jl_hide_meta';
		}
		if ( 'yes' === $module['jl_hide_desc'] ) {
			$atts_style[] = 'jl_hide_desc';
		}
		if ( 'yes' === $module['jl_hide_review'] ) {
			$atts_style[] = 'jl_hide_review';
		}
		if ( 'yes' === $module['jl_hide_line'] ) {
			$atts_style[] = 'jl_hide_line';
		}
		if ( 'yes' === $module['jl_hide_col_line'] ) {
			$atts_style[] = 'jl_hide_col_line';
		}		
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="jl_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php wesper_get_ajax_attributes( $module, $query_data ); ?>>
		<?php wesper_block_tabs_link( $module ); ?>
		<?php
		if ( $query_data->have_posts() ) :
			$atts_style = 'jl-roww jl_contain jl_cgrid_wrap';
		if ( ! empty( $module['row_style_mian'] ) ) {
			$atts_style .= ' ' . $module['row_style_mian'];
		}
		?>
		<div class="jl_grid_wrap_f jl_wrap_eb jl_wrap_eb jl_clear_at">
			<div class="<?php echo esc_attr( $atts_style ); ?>">
			<?php
			wesper_mgrid_listing( $module, $query_data );
			echo '</div>';
			wesper_blocknav( $module, $query_data );
			echo '</div></div>';
			wp_reset_postdata();
		endif;
		return ob_get_clean();
	}
}
if ( ! function_exists( 'wesper_block_tabs_link' ) ) :
	function wesper_block_tabs_link( $module ) {
		if ( empty( $module['tabs_link'] ) || empty( $module['blockid'] ) ) {
			return;
		}
		if ( empty( $module['tabs_link_ids'] ) ) {
			$module['tabs_link_ids'] = '';
		}

		if ( empty( $module['tabs_link_label'] ) ) {
			$module['tabs_link_label'] = esc_html__('all', 'wesper');
		}
		$data = wesper_add_settings_tabs_links( $module['tabs_link'], $module['tabs_link_ids'] );

		if ( empty( $data ) || ! is_array( $data ) ) {
			return;
		} ?>
		<div id="<?php echo 'ajax_filter_' . $module['blockid']; ?>" class="jl_ajax_w jl_clear_at">
			<div class="jl_ajax_c jl_clear_at">
				<span class="ajax_nav_item"><a href="#" class="jl-block-link jl-tab-link jl-ac-m" data-ajax_filter_val="0"><?php echo esc_html( $module['tabs_link_label'] ); ?></a></span>
				<?php foreach ( $data as $item ) : ?>
					<span class="ajax_nav_item"><a href="#" class="jl-block-link jl-tab-link" data-ajax_filter_val="<?php echo esc_attr( $item['id'] ); ?>"><?php echo esc_html( $item['name'] ); ?></a></span>
				<?php endforeach; ?>
			</div>
		</div>
	<?php
	}
endif;

if ( ! function_exists( 'wesper_mgrid_listing' ) ) :
	function wesper_mgrid_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
				?>
				<div class="jl_cgrid_layout">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="jl_img_holder">
			        <div class="jl_imgw jl_radus_e">
			            <div class="jl_imgin">
								<?php
								if ($module['jl_cus_img'] != '' ) {
									the_post_thumbnail($module['jl_cus_img']);
								}else{
									the_post_thumbnail('wesper_layouts');
								}?>
			            </div>
			            <?php wesper_video_media(get_the_ID());?>
			            <?php wesper_review_bar(get_the_ID(), get_post_meta( get_the_ID(), true ));?>
			            <a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
						<?php wesper_post_tumb_cat(get_the_ID());?>
			        </div>
			        </div>
			    <?php }?>
			    <div class="jl_fe_text">
			        <?php wesper_post_cat(get_the_ID());?>
			        <h3 class="jl_fe_title"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>
			        <p class="jl_fe_des"><?php echo wp_trim_words( get_the_excerpt(), 23, '...' );?> </p>
			        <?php wesper_post_meta(get_the_ID());?>
			    </div>
			</div>
			<?php
			endwhile;
		endif;
	}
endif;
