<?php
if ( ! function_exists( 'wesper_xsg' ) ) {
	function wesper_xsg( $attrs ) {
		$module = shortcode_atts( array(
			'blockid'            => '',
			'section_style'      => 'jl_sg',
			'post_type'          => 'post',
			'term_slugs'         => '',
			'post_type_tax'      => '',
			'category'           => '',
			'categories'         => '',
			'format'             => '',
			'tags'               => '',
			'author'             => '',
			'post_not_in'        => '',
			'post_in'            => '',
			'order'              => '',
			'posts_per_page'     => '',
			'offset'             => '',			
			'pagination'         => '',
			'jl_hide_cat'        => '',
			'jl_hide_author'     => '',
			'jl_hide_date'       => '',
			'jl_hide_meta'       => '',
			'jl_hide_desc'       => '',
			'jl_hide_review'     => '',			
			'jl_show_num'        => '',
			'jl_hide_line'       => '',
			'jl_hide_col_line'   => '',
			'jl_light_mode'      => '',
			'jl_cus_img'     => '',
			'ignore_sticky_posts' => '',
		), $attrs );		
		$module['style_mian']         = 'jl-main-block';
		$module['row_style_mian'] = 'jl-col-row';
		$total_posts = $module['posts_per_page'];		
		$query_data = wesper_query( $module );
		$module['posts_per_page'] = $total_posts;
		ob_start();
		$atts_style   = array();
		$atts_style[] = 'block-section';		
		if ( ! empty( $module['style_mian'] ) ) {
			$atts_style[] = $module['style_mian'];
		}
		if ( 'yes' === $module['jl_hide_cat'] ) {
			$atts_style[] = 'jl_hide_cat';
		}
		if ( 'yes' === $module['jl_hide_author'] ) {
			$atts_style[] = 'jl_hide_author';
		}
		if ( 'yes' === $module['jl_hide_date'] ) {
			$atts_style[] = 'jl_hide_date';
		}
		if ( 'yes' === $module['jl_hide_meta'] ) {
			$atts_style[] = 'jl_hide_meta';
		}
		if ( 'yes' === $module['jl_hide_desc'] ) {
			$atts_style[] = 'jl_hide_desc';
		}
		if ( 'yes' === $module['jl_hide_review'] ) {
			$atts_style[] = 'jl_hide_review';
		}		
		if ( 'yes' === $module['jl_show_num'] ) {
			$atts_style[] = 'jl_show_num';
		}
		if ( 'yes' === $module['jl_hide_line'] ) {
			$atts_style[] = 'jl_hide_line';
		}
		if ( 'yes' === $module['jl_hide_col_line'] ) {
			$atts_style[] = 'jl_hide_col_line';
		}
		if ( 'yes' === $module['jl_light_mode'] ) {
			$atts_style[] = 'jl_light_mode';
		}
		$atts_style = implode( ' ', $atts_style ); ?>
		<div id="<?php echo esc_attr( $module['blockid'] ); ?>" class="jl_clear_at <?php echo esc_attr( $atts_style ); ?>" <?php wesper_get_ajax_attributes( $module, $query_data ); ?>>
			<?php
			if ( $query_data->have_posts() ) :
				$atts_style = 'jl-roww jl_contain';		
			if ( ! empty( $module['row_style_mian'] ) ) {
				$atts_style .= ' ' . $module['row_style_mian'];
			} ?>
			<div class="jl_grid_wrap_f jl_wrap_eb jl_xsgrid jl_clear_at">
				<div class="<?php echo esc_attr( $atts_style ); ?>">
					<div class="jl_fli_wrap">			
					<?php wesper_xsg_listing( $module, $query_data );?>	
					</div>				
					<?php wesper_blocknav( $module, $query_data );?>					
				</div>
			</div>
		</div>
		<?php	
		wp_reset_postdata();			
		endif;
		return ob_get_clean();
	}
}

if ( ! function_exists( 'wesper_xsg_listing' ) ) :
	function wesper_xsg_listing( $module = array(), $query_data = null ) {
		if ( method_exists( $query_data, 'have_posts' ) ) :
			while ( $query_data->have_posts() ) :
				$query_data->the_post();
			?>
			<div class="jl_mmlist_layout jl_lisep jl_risep jl_li_num">
				<div class="jl_li_in">
			    <?php if ( has_post_thumbnail()) {?>
			        <div class="jl_img_holder">
				        <div class="jl_imgw jl_radus_e">
				            <div class="jl_imgin">
				                <?php the_post_thumbnail('wesper_small');?>
				            </div>				            
				            <span class="jl_li_lbl"></span>
				            <a class="jl_imgl" aria-label="<?php the_title()?>" href="<?php the_permalink();?>"></a>
				        </div> 
			        </div>
			    <?php }?>                            
			    <div class="jl_fe_text">    
				<?php wesper_post_small_cat(get_the_ID());?>
			        <h3 class="jl_fe_title jl_txt_2row"><a href="<?php the_permalink(); ?>"><?php the_title()?></a></h3>			
			        <?php wesper_post_meta_date(get_the_ID());?>                
			    </div>
			</div>
			</div>
			<?php
			endwhile;			
		endif;
	}
endif;